#include <struct.h>
#include "FloatBar.h"
#include "Change.h"
#include "resource.h"

extern CString    KnownObjects[60];
extern long       numnames;
extern HINSTANCE  dll, app;

BEGIN_MESSAGE_MAP(CFCEFloatBar, CRollUpBar)
END_MESSAGE_MAP()


////////////////////////////////
//globals
CFCEFloatBar*  pBar;


CFCEFloatBar::CFCEFloatBar(CWnd* powner) : CRollUpBar()
{
  Owner = powner;

  Create( Owner,
      IDD_DIALOGBAR,
      CBRS_RIGHT | CBRS_LEFT | CBRS_NOALIGN, IDD_DIALOGBAR);

  ObjIndex  = -1;
  NumOfSelected = 0;
  Multiple  = FALSE;

  numobjs  = 3;
  numvert  = 1;
  numface  = 18;

  objsgroup[0] = IDC_OBJECT_COMBO;
  objsgroup[1] = IDC_OBJECT_CHANGE;
  objsgroup[2] = IDC_OBJECT_ACTUALLY;
  
  vertgroup[0] = IDC_VERTSCHECK;

  facegroup[0] = IDC_CHECK1;
  facegroup[1] = IDC_CHECK2;
  facegroup[2] = IDC_CHECK3;
  facegroup[3] = IDC_CHECK4;
  facegroup[4] = IDC_CHECK5;
  facegroup[5] = IDC_CHECK6;
  facegroup[6] = IDC_CHECK7;
  facegroup[7] = IDC_CHECK8;
  facegroup[8] = IDC_CHECK9;
  facegroup[9] = IDC_CHECK10;
  facegroup[10]= IDC_CHECK11;
  facegroup[11]= IDC_CHECK12;
  facegroup[12]= IDC_CHECK13;
  facegroup[13]= IDC_CHECK14;
  facegroup[14]= IDC_CHECK15;
  facegroup[15]= IDC_CHECK16;
  facegroup[16]= IDC_CHECK18;
  facegroup[17]= IDC_CHECK20;

  KnownObjects[0] = ":HB";  KnownObjects[1] = "High detailed body";
  KnownObjects[2] = ":HLFW";  KnownObjects[3] = "High detailed left front wheel";
  KnownObjects[4] = ":HRFW";  KnownObjects[5] = "High detailed right front wheel";
  KnownObjects[6] = ":HLRW";  KnownObjects[7] = "High detailed left rear wheel";
  KnownObjects[8] = ":HRRW";  KnownObjects[9] = "High detailed right rear wheel";
  KnownObjects[10]= ":HLMW";  KnownObjects[11]= "High detailed left middle wheel";
  KnownObjects[12]= ":HRMW";  KnownObjects[13]= "High detailed right middle wheel";
  KnownObjects[14]= ":MB";  KnownObjects[15]= "Medium detailed body";
  KnownObjects[16]= ":MLFW";  KnownObjects[17]= "Medium detailed left front wheel";
  KnownObjects[18]= ":MRFW";  KnownObjects[19]= "Medium detailed right front wheel";
  KnownObjects[20]= ":MLRW";  KnownObjects[21]= "Medium detailed left rear wheel";
  KnownObjects[22]= ":MRRW";  KnownObjects[23]= "Medium detailed right rear wheel";
  KnownObjects[24]= ":MLMW";  KnownObjects[25]= "Medium detailed left middle wheel";
  KnownObjects[26]= ":MRMW";  KnownObjects[27]= "Medium detailed right middle wheel";
  KnownObjects[28]= ":LB";  KnownObjects[29]= "Low detailed body";
  KnownObjects[30]= ":TB";  KnownObjects[31]= "Very low detailed (tiny) body";
  KnownObjects[32]= ":OND";  KnownObjects[33]= "Drivers' hair and steering wheel";
  KnownObjects[34]= ":OD";  KnownObjects[35]= "Driver, holding steering wheel";
  KnownObjects[36]= ":OH";  KnownObjects[37]= "Driver head";
  KnownObjects[38]= ":ODL";  KnownObjects[39]= "Dashboard (highlighted)";
  KnownObjects[40]= ":OLM";  KnownObjects[41]= "Left external mirror";
  KnownObjects[42]= ":ORM";  KnownObjects[43]= "Right external mirror";
  KnownObjects[44]= ":OLB";  KnownObjects[45]= "Left front brake";
  KnownObjects[46]= ":ORB";  KnownObjects[47]= "Right front brake";
  KnownObjects[48]= ":OL";  KnownObjects[49]= "Popup light";
  KnownObjects[50]= ":OT";  KnownObjects[51]= "Top of convertibles (soft/hard top)";
  KnownObjects[52]= "Dummy:";  KnownObjects[53]= "Dummy";
  numnames = 27;//54 / 2

  SetWindowText("FCE Custom Settings"); //MUST Match GetProcName()!!!
  pBar = this;
}


CFCEFloatBar::~CFCEFloatBar()
{
}


//void CFCEFloatBar::OnUpdateCmdUI( CFrameWnd* pTarget, BOOL bDisableIfNoHndler )
//{
//  CRollUpBar::OnUpdateCmdUI(pTarget, FALSE);
//}



BOOL CFCEFloatBar::OnCmdMsg( UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo )
{
  if (!CurrentState.CurrentParams.Objects || !CurrentState.CurrentParams.sysp)
    return TRUE; //stop


  tProcParams* params = &CurrentState.CurrentParams;

  DWORD  update = Z3D_PLUGRESULT_REDRAW;

  if (nID == IDC_APPLY)
  {
    if (!(CurrentState.IsLevel(Z3D_LEVEL_VERTICES) ||
      CurrentState.IsLevel(Z3D_LEVEL_FACES)))
      return TRUE;

    update |=  Z3D_PLUGRESULT_VIEWSREDRAW | Z3D_PLUGRESULT_MISCCHANGED;
    //////////// perofrm appying flags //////////////
    long vflaghas=0;
    int  i;
    CString str;

    Backup(Z3D_BACKUP_FLAGS, "Change faces flags", FALSE, params);

    if (CurrentState.IsLevel(Z3D_LEVEL_VERTICES))
    {//vert level
      ObjCount = pBar->ObjIndex;
      vflaghas = ((CButton*)pBar->GetDlgItem(pBar->vertgroup[0]))->GetCheck();
      if (vflaghas != 2)//2 is unchanged
      for (VertCount = 0; VertCount < params->Objects->ObjSet[ObjCount].VertTable->VertAmount; VertCount++)
        if (params->Objects->ObjSet[ObjCount].VertTable->Table[VertCount].Selected() && 
          !params->Objects->ObjSet[ObjCount].VertTable->Table[VertCount].Hidden() &&
          !params->Objects->ObjSet[ObjCount].VertTable->Table[VertCount].Disabled())
        {
          if (vflaghas==0)
            params->Objects->ObjSet[ObjCount].VertTable->Table[VertCount].UnSetFlag(Z3D_FLAG_MISC1);
          else
            params->Objects->ObjSet[ObjCount].VertTable->Table[VertCount].SetFlag(Z3D_FLAG_MISC1);
        }
    }//vert level
    else
    if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
    {//face level
      ObjCount = pBar->ObjIndex;

      long setf = 0;
      long unsetf = 0;
      BOOL foundmat = FALSE;
      for (i = 0; i < 16; i++)
      {
        vflaghas = ((CButton*)pBar->GetDlgItem(pBar->facegroup[i]))->GetCheck();
        if (vflaghas == 1)
          setf |= 0x01 << i;
        if (vflaghas == 0)
          unsetf |= 0x01 << i;
      }
      vflaghas = ((CButton*)pBar->GetDlgItem(pBar->facegroup[16]))->GetCheck();
      if (vflaghas == 1)
        setf |= 0x01 << 17;
      if (vflaghas == 0)
        unsetf |= 0x01 << 17;
      vflaghas = ((CButton*)pBar->GetDlgItem(pBar->facegroup[17]))->GetCheck();
      if (vflaghas == 1)
        setf |= 0x01 << 19;
      if (vflaghas == 0)
        unsetf |= 0x01 << 19;
      for (FaceCount = 0; FaceCount < params->Objects->ObjSet[ObjCount].FaceTable->FaceAmount; FaceCount++)
        if (params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].Selected() && 
          !params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].Hidden() &&
          !params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].Disabled())
        {//change flags to this face
          params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].SetMiscFlag(0,
            params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].GetMiscFlag(0)
            & (~unsetf) | setf);
          if (setf & 0x01)
          {//set noChrome
            params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].nRenderFlags |= NoBlend;
          }//set noChrome
          if (unsetf & 0x01)
          {//unset noChrome
            params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].nRenderFlags &= ~NoBlend;
          }//unset noChrome
          if (setf & 0x02)
          {//set HighChrome
            params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].nRenderFlags |= HighBlend;
          }//set HighChrome
          if (unsetf & 0x02)
          {//unset HighChrome
            params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].nRenderFlags &= ~HighBlend;
          }//unset HighChrome
          if (setf & 0x04)
          {//set nocull
            params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].nRenderFlags |= CullNone;
          }//set nocull
          if (unsetf & 0x04)
          {//unset nocull
            params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].nRenderFlags &= ~CullNone;
          }//unset nocull

          if (setf & 0x08)
          {//set semitrans
            params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].nRenderFlags |= SemiTransparent;
          }//set semitrans
          if (unsetf & 0x08)
          {//unset semitrans
            params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].nRenderFlags &= ~SemiTransparent;
          }//unset semitrans
        }//change flags to this face
    }//face level
    params->Objects->ObjSet[pBar->ObjIndex].nRequire = Z3D_PLUGRESULT_REDRAW;

    //////////// perofrm appying flags //////////////
    CurrentState.CurrentParams.sysp( Z3D_REQUEST_UPDATEMENT,
      CurrentState.CurrentParams.Objects,
      NULL,
      (long*)&update,
      NULL);
    return TRUE;
  }

  if (nID == IDC_OBJECT_CHANGE)
  {
    AfxSetResourceHandle(dll);
    CChangeDialog diagobj(IDD_CHANGEDIALOG, AfxGetMainWnd(), params->Objects->ObjSet[pBar->ObjIndex].ObjectName);
    if (diagobj.DoModal() != IDOK)
      update = 0;
    else
    {
      NumOfSelected = 0;
      update = Z3D_PLUGRESULT_VIEWSREDRAW | Z3D_PLUGRESULT_LEVELCHANGED;
    }
    AfxSetResourceHandle(app);
    if (update !=0)
      CurrentState.CurrentParams.sysp( Z3D_REQUEST_UPDATEMENT,
        CurrentState.CurrentParams.Objects,
        NULL,
        (long*)&update,
        NULL);
    return TRUE;
  }

////////////////////////////////////////////////////////////////////////////////////
// process standart CWnd's OnCmdMsg. If not handled, process it through CRollUpBar'
  
  if (!CWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
    return CRollUpBar::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
  else
    return TRUE;
}


void Updatements(tProcParams* params)
{//react scene selection and other updatements
  if (pBar->Multiple || (pBar->ObjIndex < 0) || (pBar->ObjIndex >= params->Objects->ObjAmount))
    return;

  long vflaghas=0;
  long flaghas[20];
  int  i;
  CString str;
  ObjCount = pBar->ObjIndex;


  if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS))
  {//objects level
    BOOL damages = FALSE;
    ((CComboBox*)pBar->GetDlgItem(pBar->objsgroup[0]))->GetWindowText(str);
    if (str.Find("[D]") >= 0)
    {
      str = str.Left(str.Find("[D]"));
      damages = TRUE;
    }
    for (i = 0; i < numnames; i++)
      if (str.Find(KnownObjects[i*2]) >= 0)
      {//found
        str = KnownObjects[(i*2)+1];
        i = numnames+1;
      }//found
    if (i == numnames+2)
    {
      if (damages)
        str+= " (damages)";
      pBar->GetDlgItem(pBar->objsgroup[2])->SetWindowText(str);
    }
    else
      pBar->GetDlgItem(pBar->objsgroup[2])->SetWindowText("Unknown object type");
  }//objects level
  else
  if (CurrentState.IsLevel(Z3D_LEVEL_VERTICES))
  {//vert level
    for (VertCount = 0; VertCount < params->Objects->ObjSet[ObjCount].VertTable->VertAmount; VertCount++)
      if (params->Objects->ObjSet[ObjCount].VertTable->Table[VertCount].Selected() && 
        !params->Objects->ObjSet[ObjCount].VertTable->Table[VertCount].Hidden() &&
        !params->Objects->ObjSet[ObjCount].VertTable->Table[VertCount].Disabled())
        if (params->Objects->ObjSet[ObjCount].VertTable->Table[VertCount].HasFlag(Z3D_FLAG_MISC1))
          vflaghas++;
    ((CButton*)pBar->GetDlgItem(pBar->vertgroup[0]))->SetCheck((vflaghas==0) ? 0 : (vflaghas==pBar->NumOfSelected) ? 1 : 2);
  }//vert level
  else
  if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
  {//face level
    
    for (i = 0; i < 20; i++)
      flaghas[i] = 0;
    for (FaceCount = 0; FaceCount < params->Objects->ObjSet[ObjCount].FaceTable->FaceAmount; FaceCount++)
      if (params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].Selected() && 
        !params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].Hidden() &&
        !params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].Disabled())
      {
        vflaghas = params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].GetMiscFlag(0);
        for (i=0; i < 20; i++)
        {
          if (i==0)
          {//noChrome
            if (params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].nRenderFlags & NoBlend)
              flaghas[i]++;
          }
          else
          if (i==1)
          {//HighChrome
            if (params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].nRenderFlags & HighBlend)
              flaghas[i]++;
          }
          else
          if (i==2)
          {//nocull
            if (params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].nRenderFlags & CullNone)
              flaghas[i]++;
          }
          else
          if (i==3)
          {//semitrans
            if (params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].nRenderFlags & SemiTransparent)
              flaghas[i]++;
          }
          else
            flaghas[i] += ((vflaghas & ((0x01)<<i))>>i);
        }
      }
    for (i = 0; i < 16; i++)
      ((CButton*)pBar->GetDlgItem(pBar->facegroup[i]))->SetCheck((flaghas[i]==0) ? 0 : (flaghas[i]==pBar->NumOfSelected) ? 1 : 2);
    ((CButton*)pBar->GetDlgItem(pBar->facegroup[16]))->SetCheck((flaghas[17]==0) ? 0 : (flaghas[17]==pBar->NumOfSelected) ? 1 : 2);
    ((CButton*)pBar->GetDlgItem(pBar->facegroup[17]))->SetCheck((flaghas[19]==0) ? 0 : (flaghas[19]==pBar->NumOfSelected) ? 1 : 2);
  }//face level
}


DWORD CALLBACK FCECustomSettingsOnLevelChanged(tProcParams* params)
{
  z3dLevels lev = CurrentState.ExpectLevel;
  int i;
  if ((lev==Z3D_LEVEL_VERTICES) && !pBar->Multiple && (pBar->NumOfSelected!=0))
  {
    for (i = 0; i < pBar->numobjs; i++)
      (pBar->GetDlgItem(pBar->objsgroup[i]))->EnableWindow(FALSE);
    for (i = 0; i < pBar->numface; i++)
      (pBar->GetDlgItem(pBar->facegroup[i]))->EnableWindow(FALSE);
    for (i = 0; i < pBar->numvert; i++)
      (pBar->GetDlgItem(pBar->vertgroup[i]))->EnableWindow(TRUE);
    
    (pBar->GetDlgItem(IDC_SELECTION_TYPE))->SetWindowText("Vertices Selected");
  }
  else
  if ((lev==Z3D_LEVEL_FACES) && !pBar->Multiple && (pBar->NumOfSelected!=0))
  {
    for (i = 0; i < pBar->numobjs; i++)
      (pBar->GetDlgItem(pBar->objsgroup[i]))->EnableWindow(FALSE);
    for (i = 0; i < pBar->numface; i++)
      (pBar->GetDlgItem(pBar->facegroup[i]))->EnableWindow(TRUE);
    for (i = 0; i < pBar->numvert; i++)
      (pBar->GetDlgItem(pBar->vertgroup[i]))->EnableWindow(FALSE);
    (pBar->GetDlgItem(IDC_SELECTION_TYPE))->SetWindowText("Faces Selected");
  }
  else
  if ((lev==Z3D_LEVEL_OBJECTS) && !pBar->Multiple && (pBar->NumOfSelected!=0))
  {
    for (i = 0; i < pBar->numobjs; i++)
      (pBar->GetDlgItem(pBar->objsgroup[i]))->EnableWindow(TRUE);
    for (i = 0; i < pBar->numface; i++)
      (pBar->GetDlgItem(pBar->facegroup[i]))->EnableWindow(FALSE);
    for (i = 0; i < pBar->numvert; i++)
      (pBar->GetDlgItem(pBar->vertgroup[i]))->EnableWindow(FALSE);
    (pBar->GetDlgItem(IDC_SELECTION_TYPE))->SetWindowText("Objects Selected");
  }
  else
  {
    for (i = 0; i < pBar->numobjs; i++)
      (pBar->GetDlgItem(pBar->objsgroup[i]))->EnableWindow(FALSE);
    for (i = 0; i < pBar->numface; i++)
      (pBar->GetDlgItem(pBar->facegroup[i]))->EnableWindow(FALSE);
    for (i = 0; i < pBar->numvert; i++)
      (pBar->GetDlgItem(pBar->vertgroup[i]))->EnableWindow(FALSE);
    if (pBar->Multiple)
    {//let know that multiple
      (pBar->GetDlgItem(IDC_SELECTION_TYPE))->SetWindowText("Multiple Selection");
    }//let know that multiple
    else
    if (pBar->NumOfSelected == 0)
      (pBar->GetDlgItem(IDC_SELECTION_TYPE))->SetWindowText("<No Selection>");
    else
      (pBar->GetDlgItem(IDC_SELECTION_TYPE))->SetWindowText("<Unsupported>");
  }
  return 0;
}


DWORD CALLBACK FCECustomSettingsOnSceneChanged(tProcParams* params)
{
  long  MarkedIndex = -1;
  long  NumSelections = 0;
  BOOL  MultipleSelection;//objects
  for  (ObjCount = 0; ObjCount < params->Objects->ObjAmount; ObjCount++)
  {
    if (CurrentState.GetLevel()==Z3D_LEVEL_VERTICES)
    {//vertices
      MultipleSelection = FALSE;
      if (params->Objects->ObjSet[ObjCount].Marked() &&
        !params->Objects->ObjSet[ObjCount].Hidden() &&
        !params->Objects->ObjSet[ObjCount].Disabled())
      {
        if (MarkedIndex == -1)
        {
          MarkedIndex = ObjCount;
          for (VertCount = 0; VertCount < params->Objects->ObjSet[ObjCount].VertTable->VertAmount; VertCount++)
            if (params->Objects->ObjSet[ObjCount].VertTable->Table[VertCount].Selected() && 
              !params->Objects->ObjSet[ObjCount].VertTable->Table[VertCount].Hidden() &&
              !params->Objects->ObjSet[ObjCount].VertTable->Table[VertCount].Disabled())
              NumSelections++;
        }
        else
          MultipleSelection = TRUE;
      }
    }
    else
    if (CurrentState.GetLevel()==Z3D_LEVEL_FACES)
    {//faces
      MultipleSelection = FALSE;
      if (params->Objects->ObjSet[ObjCount].Marked() &&
        !params->Objects->ObjSet[ObjCount].Hidden() &&
        !params->Objects->ObjSet[ObjCount].Disabled())
      {
        if (MarkedIndex == -1)
        {
          MarkedIndex = ObjCount;
          for (FaceCount = 0; FaceCount < params->Objects->ObjSet[ObjCount].FaceTable->FaceAmount; FaceCount++)
            if (params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].Selected() && 
              !params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].Hidden() &&
              !params->Objects->ObjSet[ObjCount].FaceTable->Table[FaceCount].Disabled())
              NumSelections++;
        }
        else
          MultipleSelection = TRUE;
      }
    }
    else
    if (CurrentState.GetLevel()==Z3D_LEVEL_OBJECTS)
    {//objects
      MultipleSelection = FALSE;
      if (params->Objects->ObjSet[ObjCount].Selected() &&
        !params->Objects->ObjSet[ObjCount].Hidden() &&
        !params->Objects->ObjSet[ObjCount].Disabled())
      {
        if (MarkedIndex == -1)
        {
          MarkedIndex = ObjCount;
          NumSelections = 1;
        }
        else
          MultipleSelection = TRUE;
      }
    }
  }


  if ((pBar->Multiple!=MultipleSelection) || (pBar->NumOfSelected == 0))
  {//change enable/disable
    pBar->Multiple = MultipleSelection;
    BOOL wasZero = (pBar->NumOfSelected == 0);
    pBar->NumOfSelected = NumSelections;
    FCECustomSettingsOnLevelChanged(params);
    if (wasZero)
      pBar->NumOfSelected = 0;
  }//change enable/disable
  
  if ((pBar->ObjIndex!=MarkedIndex) ||
    (pBar->NumOfSelected!=NumSelections))
  {//changed selection
    pBar->ObjIndex = MarkedIndex;
    pBar->NumOfSelected = NumSelections;
    pBar->Multiple = MultipleSelection;
    (pBar->GetDlgItem(IDC_SELECTION_AMOUNT))->SetWindowText(Int2String(pBar->NumOfSelected));
    if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS))
    {
      CComboBox* pCombo = ((CComboBox*)pBar->GetDlgItem(pBar->objsgroup[0]));
      pCombo->ResetContent();
      for (ObjCount = 0; ObjCount < params->Objects->ObjAmount; ObjCount++)
      {
        pCombo->AddString(params->Objects->ObjSet[ObjCount].ObjectName);
      }
      pCombo->SetCurSel(MarkedIndex);
    }
    if (!pBar->Multiple)
      Updatements(params);
  }//changed selection


  return 0;
}


DWORD CALLBACK FCECustomSettingsOnMiscChanged(tProcParams* params)
{
  pBar->NumOfSelected = -1;//to force updatements
  FCECustomSettingsOnSceneChanged(params);
  return 0;
}
